﻿/*
	VERSION:		1.0
	
	USAGE: 
		#include "functions/queueLoad.as"
		getFileList = _this.queueLoad("files\\fileList.txt", myCache);
		getFileList.then = function( fileContents_str ){}
		
		
		#include "functions/queueLoad.as"
		_this.queueLoad( "charset\\image.png", myCache)
		.then = function( fileContents_bmp ){
			// 
		}// after loading()
		
		
		#include "functions/queueLoad.as"
		var myPath = "charset\\image.png";
		_this.queueLoad( myPath, myCache)
		.then = function( fileContents_bmp ){
			sendEvent("loadFile", {
				path: myPath, 
				image: fileContents_bmp
			});// sendEvent()
		}// after loading()
		
		
	WHAT THIS DOES: 
		Returns a promise for a requested file and queues the file to be loaded later.  (image, swf, or text)
		Files are loaded one at a time.  (when one finishes loading,  the next file starts loading)
		The same file won't get loaded more than once.  Repeated requests for a queued file returns the same promise for a single load of that file.
		Cached files are returned as immediately resolved promises.  (as if they loaded instantly)  (if a cache is provided)
		The most recently added files are loaded first.
		
		Automatically updates the provided cache when loading completes.  (if a cache is provided)
		
	
	LEAKS: 
		runFunc()
		_this
		queueLoad()
*/
if(!_this)		_this = this;
function runFunc( func ){
	return func.apply( _this, arguments.slice() );
}// runFunc()



runFunc(function(){
	#include "functions/VOW.as"
	#include "functions/VOW/loadFile.as"
	#include "functions/VOW/loadBitmap.as"
	
	var loadQueue = [];
	var itemsBeingLoaded = 0;
	
	_this.queueLoad = function( filePath, cache ){
		// return a promise for items that are already cached
		if( cache && cache[ filePath ] )		return VOW.make().keep(  cache[ filePath ]  );
		// else...
		
		// if:   not already in the cache
		// return a promise for items that are already being loaded
		var itemInQueue = getQueuedItem( filePath );
		if( itemInQueue.prom )			return itemInQueue.prom;
		// else...
		
		// if:   not already in the queue
		var prom = VOW.make();
		// queue this item
		loadQueue.push( {
			filePath: filePath, 
			prom: prom
		} );
		
		// if not loading anything other than this
		// then start loading items
		if( itemsBeingLoaded === 0)		loadNextItem( cache );
		
		return prom;
	}// queueLoad()
	
	
	
	function getQueuedItem( filePath ){
		for(var q=loadQueue.length-1; q>=0; q--){
			if( loadQueue[ q ].filePath === filePath )		return loadQueue[ q ];
		}
		return undefined;
	}// getQueuedItem()
	
	
	
	// async loop
	function loadNextItem( cache ){
		// loop stops when queue is empty
		// keep loading items until the queue is empty
		if( loadQueue.length === 0 )		return;
		// else...
		
		// loop decrements the queue each time it runs
		// remove the last item added to the queue  (most recent)
		var thisItem = loadQueue.pop();
		// start loading that item
		itemsBeingLoaded++;
		var currentLoad_prom = cacheLoad( thisItem.filePath, cache );
		currentLoad_prom.then( function( contents ){
			thisItem.prom.keep( contents );
		}, thisItem.prom.doBreak );
		currentLoad_prom.then( done, done );
		// succeed or fail,  continue
		function done(){
			itemsBeingLoaded--;
			loadNextItem( cache );
		}// done()
		// loadNextItem( cache );
	}// loadNextItem()
	
	
	
	/*
		Returns a promise for either a newly loaded file, or a cached file.  (if a cache is provided)
		Automatically updates the provided cache when loading completes.  (if a cache is provided)
	*/
	// _this.cacheLoad = cacheLoad;
	function cacheLoad( filePath, cache ){
		if( !filePath )		return;
		
		// return a promise for items that are already cached
		if( cache && cache[ filePath ] )		return VOW.make().keep(  cache[ filePath ]  );
		
		// resolve params
		var prom = VOW.make.doBreak();
		
		
		// figure out what kind of file this is
		var extAt = filePath.lastIndexOf('.');
		var ext = filePath.substr( extAt+1 );
		var loadAs = 'text';
		// text
		if( ext === "txt" )		loadAs = 'text';
		if( ext === "xml" )		loadAs = 'text';
		if( ext === "json" )	loadAs = 'text';
		// image
		if( ext === "jpg" )	loadAs = 'image';
		if( ext === "jp3g" )	loadAs = 'image';
		if( ext === "gif" )	loadAs = 'image';
		if( ext === "png" )	loadAs = 'image';
		if( ext === "swf" )	loadAs = 'image';
		
		
		// load the file
		// if:  text file
		if( loadAs === 'text' ){
			prom = loadFile( filePath );
		}// if:  text file
		
		// if:  image/swf file
		if( loadAs === 'image' ){
			prom = loadBitmap( filePath );
		}// if:  image/swf file
		
		
		// update the cache
		if( cache ){
			prom.then = function( contents ){
				if( contents === undefined )		return;
				cache[ filePath ] = contents;
			}// after loading
		}// if:   a cache exists
		
		
		return prom;
	}// cacheLoad()
});// runFunc()